execute_process(COMMAND ${RPMBUILD_EXECUTABLE} --querytags
                OUTPUT_VARIABLE RPMBUILD_CAPS
                RESULT_VARIABLE RPMBUILD_CAPS_RESULT)

if(NOT RPMBUILD_CAPS_RESULT)
  string(REPLACE "\n" ";" RPMBUILD_CAPS "${RPMBUILD_CAPS}")
  cmake_policy(PUSH)
    cmake_policy(SET CMP0057 NEW)
    if(SUGGESTS IN_LIST RPMBUILD_CAPS)
      set(should_contain_suggests_tag_ true)
    endif()
  cmake_policy(POP)
endif()

# Only verify that suggests tag is present only if that tag is supported.
# If it is not supported the rpm package was corretly generated by ignoring
# that tag and that was already checked by expected files test.
if(should_contain_suggests_tag_)
  execute_process(COMMAND ${RPM_EXECUTABLE} -q --suggests -p "${FOUND_FILE_1}"
                  WORKING_DIRECTORY "${CPACK_TEMPORARY_DIRECTORY}"
                  RESULT_VARIABLE rpm_result_
                  OUTPUT_VARIABLE rpm_output_
                  ERROR_VARIABLE error_variable_
                  OUTPUT_STRIP_TRAILING_WHITESPACE)

  if(rpm_result_ OR NOT rpm_output_ STREQUAL "libsuggested")
    message(FATAL_ERROR "RPM_SUGGESTED package error: no suggested packages"
        " (result: '${rpm_result_}'; output: '${rpm_output_}';"
        " error: '${error_variable_}')")
  endif()
endif()
